﻿/*
tip_modal.js  v. 1.0

The latest version is available at
http://sourceforge.net/projects/wztip
or http://sf.net/projects/wztip

Initial Author:  #1 $tunna
Created:  Monday, October 29, 2007 / 03:25 AM GMT+1
Last Modified:  Saturday, June 13, 2009 / 02:27 PM EST

Thank You to latecomerx for fixing the overlay & IE bugs:
http://latecomerx.com

License:  LGPL

*** NOTE ***

this is the result of relentless hacking of Walter Zorn's original code.
I don't even know JavaScript, LOL.....

Modal code is directly "borrowed" from Hunlock.com Public Domain snippets
"LoadingAnimation.gif" & code is from Smoothbox

TO DO:

1.  cleanup the code

Known Issues:

***NONE***

About:

tip_modal is an Extension for the wz_tooltip.js tooltip library.
Makes a tooltip modal, disabling interaction w/ the other portions of the page.
The tooltip must be sticky for this extension to function.
*/

// Here we define new global configuration variable(s) (as members of the
// predefined "config." class).
// From each of these config variables, wz_tooltip.js will automatically derive
// a command which can be passed to Tip() or TagToTip() in order to customize
// tooltips individually. These command names are just the config variable
// name(s) translated to uppercase,
// e.g. from config. CenterWindow a command CENTERWINDOW will automatically be
// created.

//===================  GLOBAL TOOPTIP CONFIGURATION  =========================//
config. IsModal = true	    // true or false - set to true if you want this to be the default behaviour
config. ModalOpacity = 25	// Lower number = less grayout higher = more of a blackout
config. ModalZindex = 0 // HTML elements with a higher zindex appear on top of the gray out
config. ModalBgcolor = '#000000'
//=======  END OF TOOLTIP CONFIG, DO NOT CHANGE ANYTHING BELOW  ==============//


// Create a new tt_Extension object (make sure that the name of that object,
// here modalwnd, is unique amongst the extensions available for
// wz_tooltips.js):
var modalwnd = new tt_Extension();

// source: http://www.hunlock.com/blogs/Snippets:_Howto_Grey-Out_The_Screen
// License: Public Domain

modalwnd.grayOut = function (vis, options) {
  // Pass true to gray out screen, false to ungray
  // options are optional.  This is a JSON object with the following (optional) properties
  // opacity:0-100         // Lower number = less grayout higher = more of a blackout
  // zindex: #             // HTML elements with a higher zindex appear on top of the gray out
  // bgcolor: (#xxxxxx)    // Standard RGB Hex color code
  // grayOut(true, {'zindex':'50', 'bgcolor':'#0000FF', 'opacity':'70'});
  // Because options is JSON opacity/zindex/bgcolor are all optional and can appear
  // in any order.  Pass only the properties you need to set.
  var options = options || {};
  var zindex = options.zindex || 50;
  var opacity = options.opacity || 70;
  var opaque = (opacity / 100);
  var bgcolor = options.bgcolor || tt_aV[MODALBGCOLOR];
  var dark=document.getElementById('darkenScreenObject');
  if (!dark) {
    // The dark layer doesn't exist, it's never been created.  So we'll
    // create it here and apply some basic styles.
    // If you are getting errors in IE see: http://support.microsoft.com/default.aspx/kb/927917
    var tbody = document.getElementsByTagName("body")[0];
    var tnode = document.createElement('div');           // Create the layer.
        tnode.style.position='absolute';                 // Position absolutely
        tnode.style.top='0px';                           // In the top
        tnode.style.left='0px';                          // Left corner of the page
        tnode.style.overflow='hidden';                   // Try to avoid making scroll bars
        tnode.style.display='none';                      // Start out Hidden
        tnode.id='darkenScreenObject';                   // Name it so we can find it later
    tbody.appendChild(tnode);                            // Add it to the web page
    dark=document.getElementById('darkenScreenObject');  // Get the object.
  }
  if (vis) {
    // Calculate the page width and height
    if( document.body && ( document.body.scrollWidth || document.body.scrollHeight ) ) {
        var pageWidth = document.body.scrollWidth+'px';
        var pageHeight = document.body.scrollHeight+'px';
    } else if( document.body.offsetWidth ) {
      var pageWidth = document.body.offsetWidth+'px';
      var pageHeight = document.body.offsetHeight+'px';
    } else {
       var pageWidth='100%';
       var pageHeight='100%';
    }
    //set the shader to cover the entire page and make it visible.
    dark.style.opacity=opaque;
    dark.style.MozOpacity=opaque;
    dark.style.filter='alpha(opacity='+opacity+')';
    dark.style.zIndex=zindex;
    dark.style.backgroundColor=bgcolor;
    dark.style.width= pageWidth;
    dark.style.height= pageHeight;
    dark.style.display='block';
  } else {
     dark.style.display='none';
  }
}

modalwnd.OnKill = function()
{
	if(tt_aV[ISMODAL])
	{
    if(tt_aV[STICKY])
		{
        modalwnd.grayOut(false);
        }

	}
};

modalwnd.OnShow = function()
{
if(tt_aV[STICKY] && tt_aV[CLICKCLOSE])
		{
        modalwnd.grayOut(true);
        }
}