<?php
/**
***************************************************************************************************
 * @Software        ClipBucket
 * @Author          Arslan Hassan, et al
 * @Copyright	    Copyright (c) 2007-2009. All Rights Reserved.
 * @URL        	    http://www.clip-bucket.com
 * @Version		    $Id: common.php 327 2009-11-21 20:15:49Z fwhite $
 * @Created 	    10-15-2007
 * @Last Modified   $Date: 2009-11-21 21:15:49 +0100 (Sat, 21 Nov 2009) $ $Author: fwhite $
 * @License		    CBLA v1 - http://cbla.cbdev.org
 **************************************************************************************************
 This source code is licensed under the terms of the CBLA v1
 http://cbla.cbdev.org
 **************************************************************************************************
 Copyright (c) 2007-2009 Clip-Bucket.com. All Rights Reserved.
 **************************************************************************************************
**/

ob_start();
define('IN_CB',true);
define('COOKIE_TIMEOUT',315360000); // 10 years
define('GARBAGE_TIMEOUT',COOKIE_TIMEOUT);
ini_set('session.gc_maxlifetime', GARBAGE_TIMEOUT);
session_set_cookie_params(COOKIE_TIMEOUT,'/');

    // setting session dir
    $sessdir = '/tmp/'.$_SERVER['HTTP_HOST'];
    // if session dir not exists, create directory
    if (!is_dir($sessdir))
    {
      @mkdir($sessdir, 0777);
    }
    //if directory exists, then set session.savepath otherwise let it go as is
    if(is_dir($sessdir))
    {
      ini_set('session.save_path', $sessdir);
    }
    session_start();

    // required files
    require_once('functions.php');
    CheckRequiredFunctions();
    SupportedOS();
    CheckExec();
    CheckInstall();
	require_once('dbconnect.php');
    require_once('classes/class.inputfilter.php');
	require_once('classes/pages.class.php');
	require_once('classes/ads.class.php');
	require_once('classes/my_queries.class.php');
	require_once('classes/user.class.php');
	require_once('classes/calcdate.class.php');
	require_once('classes/signup.class.php');
	require_once('classes/image.class.php');
	require_once('classes/upload.class.php');
	require_once('classes/groups.class.php');
	require_once('classes/stats.class.php');
	require_once('languages.php');
    require_once('classes/SHP.class.php');
	
	/**
	 * define DISABLE_WRITE_CHECK to
	 * disable these checks
	 */
	if(!defined('DISABLE_WRITE_CHECK'))
	{
		IsCacheWritable();
		IsFilesWritable();
		IsFilesSubDirsWritable();
		IsImagesWritable();
		IsImagesSubDirsWritable();
		IsLogsWritable();
	}

    $InputFilter    = new InputFilter();
	$pages 		    = new pages();
	$myquery 	    = new myquery();
	$userquery 	    = new userquery();
	$calcdate	    = new CalcDate();
	$signup 	    = new signup();
	$Upload 	    = new Upload();
	$groups 	    = new groups();
	$stats 		    = new stats();
	$ads_query 	    = new AdsManager();
    $SHP            = new SHP();
/*    $SHP->developer_set_hook('test');
    $SHP->load_plugins();*/

	$row            = $myquery->Get_Website_Details();
	$email_data     = $myquery->Get_Email_Settings();
	//$ads          = $myquery->Get_Advertisments();
	$ads_array 	    = array();
	
    define('BASEDIR',$row['basedir']);
    define('BASEURL',$row['baseurl']);
    define('USE_VIDENC',$row['use_videnc']);
    define('VIDENC_KEY',$row['videnc_key']);
    define('TROUBLESHOOT',$row['enable_troubleshooter']);
    define('FFMPEG_CHECK',$row['check_ffmpeg']);
    define('DEBUG_LEVEL', $row['debug_level']);
    define('LOG_ACCESS',@$row['log_access']);
    define('ALLOW_CONTACT',$row['allow_contact']);

    if(DEBUG_LEVEL == 1)
    {
    error_reporting(E_ALL);
    ini_set('display_errors', '1');
    }
    elseif(DEBUG_LEVEL == 2)
    {
	error_reporting(E_ALL ^ E_NOTICE);
    ini_set('display_errors', '1');
    }
    else
    {
    error_reporting(0);
    ini_set('display_errors', '0');
    }

    // site details
    define('CB_VERSION', $row['version']);
    define('RELEASE_DATE', $row['release_date']);
    define('TITLE',$row['site_title']);
	define('SLOGAN',$row['site_slogan']);
    define('GOOGLE_ANALYTICS', $row['google_analytics']);
    define('SITE_CLOSED',$row['closed']);

    if(isset($_COOKIE['sitelang']))
    {
    $sitelang = $_COOKIE['sitelang'];
    }
    if(!isset($sitelang))
    {
    define('LANG',$row['default_site_lang']);
    setcookie('sitelang', $row['default_site_lang'], time()+315360000, '/');
    }
    elseif(!file_exists(BASEDIR.'/lang/'.$sitelang))
    {
    define('LANG',$row['default_site_lang']);
    setcookie('sitelang', $row['default_site_lang'], time()+315360000, '/');
    }
    else
    {
    define('LANG',$sitelang);
    }

    // define session timeout
    define('SESSION_TIMEOUT', $row['session_timeout']);

    // SEO
 	define('SEO',$row['seo']); //Set yes / no

    // registration & e-mail settings
  	define('EMAIL_VERIFICATION',$row['email_verification']);
	define('ALLOW_REG',$row['allow_reg']);
	define('WEBSITE_EMAIL',$email_data['website_email']);
	define('SUPPORT_EMAIL',$email_data['support_email']);
	define('WELCOME_EMAIL',$email_data['welcome_email']);
	@define('VIDEO_REQUIRE_LOGIN',$row['video_require_login']);
	define('ACTIVATION',$row['activation']);
	
    // video & channel listings
    define('GUEST_CHANNEL_LIST',$row['guest_view_channel_list']);
    define('GUEST_VIDEO_LIST',$row['guest_view_video_list']);
    define('GUEST_GROUP_LIST',$row['guest_view_group_list']);
    define('GUEST_PROFILE_VIEW',$row['guest_view_profiles']);
  	define('VLISTPP',$row['videos_list_per_page']);				//Video List Per page
	define('VLISTPT',$row['videos_list_per_tab']);				//Video List Per tab
	define('CLISTPP',$row['channels_list_per_page']);			//Channels List Per page
	define('CLISTPT',$row['channels_list_per_tab']);			//Chaneels List Per tab
	define('GLISTPP',$row['groups_list_per_page']);				//Groups List Per page
	define('SLISTPP',$row['search_list_per_page']);				//Search Results List Per page
	define('RVLIST',$row['recently_viewed_limit']);				//Search Results List Per page
	
    // video options
  	define('VIDEO_COMMENT',$row['video_comments']);
	define('VIDEO_RATING',$row['video_rating']);
	define('COMMENT_RATING',$row['comment_rating']);
	define('VIDEO_DOWNLOAD',$row['video_download']);
	define('VIDEO_EMBED',$row['video_embed']);
    define('TEMPLATEFOLDER','styles');							//Template Folder Name, usually STYLES
	
	if($row['allow_template_change'] == 1){
	    if(isset($_COOKIE['sitestyle']))
        {
		$sitestyle = $_COOKIE['sitestyle'];
		if (!$sitestyle || !$myquery->IsTemplate($sitestyle))
		{
		define('TEMPLATE',$row['template_dir']);
		setcookie('sitestyle', $row['template_dir'], time()+315360000, '/');
		}
        elseif(!file_exists(BASEDIR.'/styles/'.$sitestyle))
        {
        define('TEMPLATE',$row['template_dir']);
        setcookie('sitestyle', $row['template_dir'], time()+315360000, '/');
        }
		else
		{
		define('TEMPLATE',$sitestyle);
		}
        }
        else
        {
		define('TEMPLATE',$row['template_dir']);
        setcookie('sitestyle', $row['template_dir'], time()+315360000, '/');
        }
	}
    else
    {
		define('TEMPLATE',$row['template_dir']);
        setcookie('sitestyle', $row['template_dir'], time()+315360000, '/');
	}

// Define Lang Select & Style Select

    define('ALLOW_LANG_SELECT',$row['allow_language_change']);
    define('ALLOW_STYLE_SELECT',$row['allow_template_change']);

	define('FLVPLAYER',$row['player_file']);
    define('SUBTITLE',$row['code_dev']);
    define('JSDIR','js');										//Javascript Directory Name
	define('VIDEODIR','videos');								//FLV Videos DIrectory
	define('ADMINDIR','admin_area');							//Admin Accissble Folder
	define('MODULEDIR',BASEDIR.'/modules');						//Modules Directory
	
//DIRECT PATHS OF VIDEO FILES
	define('FILES_DIR',BASEDIR.'/files');
	define('VIDEOS_DIR',FILES_DIR.'/videos');
	define('THUMBS_DIR',FILES_DIR.'/thumbs');
	define('ORIGINAL_DIR',FILES_DIR.'/original');
	define('TEMP_DIR',FILES_DIR.'/temp');

//DIRECT URL OF VIDEO FILES
	define('FILES_URL',BASEURL.'/files');
	define('VIDEOS_URL',FILES_URL.'/videos');
	define('THUMBS_URL',FILES_URL.'/thumbs');
	define('ORIGINAL_URL',FILES_URL.'/original');
	define('TEMP_URL',FILES_URL.'/temp');
	
 //Required Settings For Video Converion
 
 	define('VBRATE', $row['vbrate']);
	define('SRATE', $row['srate']);
	define('SBRATE', $row['sbrate']);
	define('R_HEIGHT', $row['r_height']);
	define('R_WIDTH', $row['r_width']);
	define('RESIZE', $row['resize']);
	define('KEEP_ORIGINAL', $row['keep_original']);
	define('MAX_UPLOAD_SIZE', $row['max_upload_size']);
	define('THUMB_HEIGHT', $row['thumb_height']);
	define('THUMB_WIDTH', $row['thumb_width']);
	define('FFMPEG_TYPE', $row['ffmpeg_type']);
	if(FFMPEG_TYPE == 's'){
		define('FFMPEG_BINARY', MODULEDIR.'/encoders/ffmpeg');
	}else{
		define('FFMPEG_BINARY', $row['ffmpegpath']);
	}
	define('FFMPEG_FLVTOOLS_BINARY', $row['flvpath']);
	define('PHP_PATH', $row['php_path']);
	define('FFMPEG_MENCODER_BINARY', $row['mencoderpath']);
	define('FFMPEG_MPLAYER_BINARY', $row['mplayerpath']);
	
	// define plugin directory
	define('PLUG_DIR',BASEDIR.'/plugins');
	
	// assign smarty tags & values
	require BASEDIR.'/includes/templatelib/Template.class.php';
	require BASEDIR.'/includes/classes/template.class.php';
	require BASEDIR.'/includes/classes/TConfig.php';
	require BASEDIR.'/includes/classes/TError.php';
    require BASEDIR.'/includes/defined_links.php';
	require_once('email_templates/template_writer.php');
	require_once(BASEDIR.'/lang/'.LANG.'/lang.php');

    // FFmpeg check
/*    if(in_array('Not Installed',LocCheck('ffmpeg'))
    || FFMPEG_BINARY == 'Not Installed')
    {
    	define('NO_FFMPEG','1');
    }*/

    if(FFMPEG_BINARY == 'Not Installed' || FFMPEG_BINARY == '')
    {
    define('NO_FFMPEG','1');
    }

    // define date for smarty loops
    define('SMARTY_LOOP_DATE',(date('Y')+1));
    Assign('smarty_loop_date',SMARTY_LOOP_DATE);

    $is_admin = $userquery->admin_check();
    if ($is_admin == 1)
    {
        define('IS_ADMIN',1);
        Assign('is_admin',IS_ADMIN);
    }

    if(!defined('IS_ADMIN'))
    {
        if(!empty($_POST))
        {
            $_POST = $InputFilter->process($_POST);
        }

        if(!empty($_GET))
        {
            $_GET = $InputFilter->process($_GET);
        }
    }    

    define('THIS_URL',curPageURL());
    Assign('THIS_URL', THIS_URL);

    // check session timeout
    if(isset($_SESSION) && isset($_SESSION['time']))
    {
    $_SESSION['last_active'] = time();
    if(SESSION_TIMEOUT > 0)
    {
	$session_life = $_SESSION['last_active'] - $_SESSION['time'];
	if($session_life > SESSION_TIMEOUT)
        {
    	  setcookie('username','',time()-3600,'/');
	      setcookie('userid','',time()-3600,'/');
	      setcookie('session','',time()-3600,'/');
          setcookie('PHPSESSID','',time()-3600,'/');
          session_unset();
          session_destroy();
          header('Location: '.BASEURL.signup_link.'');
        }
     if($session_life < SESSION_TIMEOUT)
     {
        setcookie(session_name(), $_COOKIE[session_name()], time()+COOKIE_TIMEOUT, '/');
		setcookie('username',$_COOKIE['username'],time()+COOKIE_TIMEOUT,'/');
		setcookie('userid',$_COOKIE['userid'],time()+COOKIE_TIMEOUT,'/');
		setcookie('session',$_COOKIE[session_name()],time()+COOKIE_TIMEOUT,'/');
        setcookie('sitelang',$_COOKIE['sitelang'],time()+COOKIE_TIMEOUT,'/');
        setcookie('sitestyle',$_COOKIE['sitestyle'],time()+COOKIE_TIMEOUT,'/');
        setcookie('PHPSESSID',$_COOKIE['PHPSESSID'],time()+COOKIE_TIMEOUT,'/');
    }
    }
    else
    {
        setcookie(session_name(), $_COOKIE[session_name()], time()+COOKIE_TIMEOUT, '/');
		setcookie('username',$_COOKIE['username'],time()+COOKIE_TIMEOUT,'/');
		setcookie('userid',$_COOKIE['userid'],time()+COOKIE_TIMEOUT,'/');
		setcookie('session',$_COOKIE[session_name()],time()+COOKIE_TIMEOUT,'/');
        if(isset($_COOKIE['sitelang']))
        {
        setcookie('sitelang',$_COOKIE['sitelang'],time()+COOKIE_TIMEOUT,'/');
        }
        else
        {
        setcookie('sitestyle',$row['default_site_lang'],time()+COOKIE_TIMEOUT,'/');
        }
        if(isset($_COOKIE['sitestyle']))
        {
        setcookie('sitestyle',$_COOKIE['sitestyle'],time()+COOKIE_TIMEOUT,'/');
        }
        else
        {
        setcookie('sitestyle',$row['template_dir'],time()+COOKIE_TIMEOUT,'/');
        }
        setcookie('PHPSESSID',$_COOKIE['PHPSESSID'],time()+COOKIE_TIMEOUT,'/');
    }
    }

    Assign('CB_VERSION',CB_VERSION);
    Assign('FFMPEG_FLVTOOLS_BINARY',FFMPEG_FLVTOOLS_BINARY);
    Assign('FFMPEG_MPLAYER_BINARY',FFMPEG_MPLAYER_BINARY);
    Assign('PHP_PATH',PHP_PATH);
    Assign('FFMPEG_BINARY',FFMPEG_BINARY);
    Assign('FFMPEG_MENCODER_BINARY',FFMPEG_MENCODER_BINARY);
    Assign('js',BASEURL.'/'.JSDIR);
	Assign('title',TITLE);
	Assign('slogan',SLOGAN);	
	Assign('flvplayer',FLVPLAYER);
	Assign('avatardir',BASEURL.'/images/avatars');
	Assign('whatis',$row['whatis']);
	Assign('category_thumbs',BASEURL.'/images/category_thumbs');
	Assign('video_thumbs',THUMBS_URL);
	//Assign('ads',$ads);
	Assign('meta_keywords',$row['keywords']);
	Assign('meta_description',$row['description']);
	Assign('email_verification',EMAIL_VERIFICATION);
	Assign('group_thumb',BASEURL.'/images/groups_thumbs');
	Assign('bg_dir',BASEURL.'/images/backgrounds');
	Assign('captcha_type',$row['captcha_type']);
	Assign('languages',$languages);
	Assign('module_dir',MODULEDIR);
	Assign('VIDEOS_URL',VIDEOS_URL);
	Assign('THUMBS_URL',THUMBS_URL);
	Assign('PLUG_URL',BASEURL.'/plugins');
	
//Remote and Embed
	Assign('remoteUpload',$row['remoteUpload']);
	Assign('embedUpload',$row['embedUpload']);
	
//Video Options
 	Assign('video_comment',$row['video_comments']);
	Assign('video_rating',$row['video_rating']);
	Assign('comment_rating',$row['comment_rating']);
	Assign('video_download',$row['video_download']);
	Assign('video_embed',$row['video_embed']);
	

//Assign Lang

	Assign('LANG',$TEMPLATE_LANG);
	Assign('langf',LANG);
    Assign('lang_count',count($languages));

//Assign Footer

	Assign('lang_changer',$row['allow_language_change']);
	Assign('template_changer',$row['allow_template_change']);
	Assign('current_template',TEMPLATE);

//Getting Template List (admin area)
	$sql = "SELECT * from template";
	$rs = $db->Execute($sql);
	$templates = $rs->getrows();

    // sort user template list (fwhite / February 05, 2009)
    foreach ($templates as $key => $temp_row) {
    $temp_name[$key]  = $temp_row[1];
    }

    // Sort the data with name ascending
    // Add data as the last parameter, to sort by the common key
    array_multisort($temp_name, SORT_ASC, $templates);
	Assign('templates', $templates);

//Assign Player Div Id
	Assign('player_div_id',$row['player_div_id']);

//Add Modules
require('modules.php');	

//Update User if logged in;
if($userquery->logincheck(FALSE)){
$userquery->UpdateLastActive($_SESSION['username']);
}

//REGISTER OBJECTS FOR SMARTY
$Smarty->assign_by_ref('pages', $pages);
$Smarty->assign_by_ref('myquery', $myquery);
$Smarty->assign_by_ref('userquery', $userquery);
$Smarty->assign_by_ref('signup', $signup);
$Smarty->assign_by_ref('Upload', $Upload);
$Smarty->assign_by_ref('groups', $groups);
$Smarty->assign_by_ref('Stats', $stats);
$Smarty->assign_by_ref('db', $db);

//Registering Ad Function
$Smarty->register_function('AD','getAd');

    // example plugin: http://phpclasses.org/browse/file/22635.html
    //execute hooks for "test" only if there are hooks to execute
/*    if ($SHP->hooks_exist('test')) {
        $SHP->execute_hooks('test');
    }*/
?>